"use-strict";

function tNumberFormatter(value, subsitute = "Kzs") {
    var formatted = '';
    var contador = value.replace(subsitute, "").replace(" ", "").trim();
    var numericValue = parseFloat(contador.replace(',', '.'));
    
    if (numericValue == 0) {
        return `AO ${numericValue},00`;
    }
    
    if (numericValue >= 1000000000) {
        formatted = (numericValue / 1000000000).toFixed(2).replace('.', ',') + 'B';
    } else if (numericValue >= 1000000) {
        formatted = (numericValue / 1000000).toFixed(2).replace('.', ',') + 'M';
    } else if (numericValue >= 1000) {
        formatted = (numericValue / 1000).toFixed(2).replace('.', ',') + 'K';
    } else {
        formatted = parseFloat(numericValue).toFixed(2).replace('.', ',');
        return "AO " + formatted; //formatted.replace(",00","");
    }
    formatted = "AO " + formatted.replace(/\B(?=(\d{3})+(?!\d))/g, " ");
    return formatted.replace(",00","");
}