<!DOCTYPE html>
<html lang="pt">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-T3c6CoIi6uLrA9TneNEoa7RxnatzjcDSCmG1MXxSR1GAsXEV/Dwwykc2MPK8M2HN" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" integrity="sha512-z3gLpd7yknf1YoNbCzqRKc4qyor8gaKU1qmn+CShxbuBusANI9QpRohGBreCFkKxLhei6S9CQXFEbbKuqLg0DA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    <style>
        :root {
            --body-bg: rgb(204, 204, 204);
            --white: #ffffff;
            --darkWhite: #ccc;
            --black: #000000;
            --dark: #615c60;
            --themeColor: #560085;
            --pageShadow: 0 0 0.5cm rgba(0, 0, 0, 0.5);
        }

        @import url('https://fonts.googleapis.com/css2?family=Arimo:wght@400;500&family=Noto+Sans:ital,wght@0,100;0,200;0,300;0,400;0,500;1,100&display=swap');

        body {
            background-color: var(--body-bg);
            -webkit-print-color-adjust: exact !important;
        }


        .page {
            background: var(--white);
            display: block;
            margin: 0 auto;
            position: relative;
            box-shadow: var(--pageShadow);
        }

        .page[size="Ticket"] {
            width: 7cm;
            overflow: hidden;
        }

        .bb {
            border-bottom: 3px solid var(--darkWhite);
        }

        .top-content {
            padding-bottom: 15px;
        }

        .logo img {
            height: 20px;
        }

        .top-left p {
            margin: 0;
        }

        .top-left .graphic-path {
            height: 40px;
            position: relative;
        }

        .top-left .graphic-path::before {
            content: "";
            height: 20px;
            background-color: var(--dark);
            position: absolute;
            left: 15px;
            right: 0;
            top: -15px;
            z-index: 2;
        }

        .top-left .graphic-path::after {
            content: "";
            height: 22px;
            width: 17px;
            background: var(--black);
            position: absolute;
            top: -13px;
            left: 6px;
            transform: rotate(45deg);
        }

        .top-left .graphic-path p {
            color: var(--white);
            height: 40px;
            left: 0;
            right: -100px;
            text-transform: uppercase;
            background-color: var(--themeColor);
            font: 26px;
            z-index: 3;
            position: absolute;
            padding-left: 10px;
        }

        .store-user {
            padding-bottom: 25px;
        }

        .store-user p {
            margin: 0;
            font-weight: 600;
        }

        .store-user .address {
            font-weight: 400;
        }

        .store-user h2 {
            color: var(--themeColor);
            font-family: 'Rajdhani', sans-serif;
        }

        .extra-info p span {
            font-weight: 400;
        }

        .table td,
        .table th {
            text-align: center;
            vertical-align: middle;
        }

        tr th:first-child,
        tr td:first-child {
            text-align: left;
        }

        .media img {
            height: 60px;
            width: 60px;
        }

        .media p {
            font-weight: 400;
            margin: 0;
        }

        .media p.title {
            font-weight: 600;
        }

        .media-body>p {
            font-weight: 600;
        }

        .balance-info .table td,
        .balance-info .table th {
            padding: 0;
            border: 0;
        }

        .balance-info tr td:first-child {
            font-weight: 600;
        }

        tfoot {
            border-top: 2px solid var(--darkWhite);
        }

        tfoot td {
            font-weight: 600;
        }

        footer {
            text-align: center;
            position: absolute;
            bottom: 30px;
            left: 0;
            right: 0;
            background: var(--white);
            padding: 3rem;
        }

        footer hr {
            margin-bottom: -22px;
            border-top: 3px solid var(--darkWhite);
        }

        footer a {
            color: var(--themeColor);
        }

        @media print {

            .page,
            .page * {
                visibility: visible;
            }

            .page {
                position: absolute;
                left: 0;
                top: 0;
                box-shadow: none;
            }

            .my-5 {
                margin: 0 !important;
            }

            @page {
                margin: 0;
            }
        }

        .tabela thead td {
            background-color: #0000000d;
        }

        .tabela td {
            text-align: left;
        }

        .tabela-principal thead {
            font-weight: 600;
        }

        .tabela-principal thead td {
            background: none;
        }

        .tabela-principal td {
            border: none;
        }
    </style>
</head>

<body>
    <div class="my-5 page" size="Ticket">
        <div class="p-3">
            <section class="top-content d-flex justify-content-between" style="padding-bottom: 0; padding-top: 1.5rem;">
                <div class="col-12" style="display: flex; justify-content: center;">
                    <div class="logo">
                        <img src="logo.png" alt="" class="img-fluid" id="logotipoDocumento" style="margin-bottom: .5rem;">
                    </div>
                </div>
            </section>
            <section class="store-user" style="padding-bottom: 0; border-bottom: 1px solid #000;">
                <div class="col-12">
                    <div class="row pb-1">
                        <div class="col-12" style="display: flex; justify-content: center; flex-direction: column;">

                            <p style="font-size: 6pt; font-family: 'Noto Sans', sans-serif; text-align: center; font-weight: bold;" id="nomeEmpresaDocumento"></p>
                            <p style="font-size: 6pt; font-family: 'Noto Sans', sans-serif; text-align: center; font-weight: bold;" id="nomeTipoDocumento"></p>
                            <p style="font-size: 6pt; font-family: 'Noto Sans', sans-serif; text-align: center; font-weight: 400; padding-bottom: 1rem;" id="viaDocumento"></p>
                            <div class="row">
                                <div class="col-md-6" style="text-align: left; font-weight: bold; font-size: 8px;">
                                    <span>Documento: </span>
                                </div>
                                <div class="col-md-6" style="text-align: right; font-size: 8px;">
                                    <span id="codigoDocumentoo"></span>
                                </div>
                                <div class="col-md-6" style="text-align: left; font-weight: bold; font-size: 8px;">
                                    <span>Data de Emissão: </span>
                                </div>
                                <div class="col-md-6" style="text-align: right; font-size: 8px;">
                                    <span id="dataEmissaoDocumento"></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <section class="store-user" style="margin-top: .3rem; padding-bottom: 0; border-bottom: 1px solid #000;">
                <div class="col-12">
                    <div class="row pb-1">
                        <div class="col-12" style="display: flex; justify-content: center; flex-direction: column;">
                            <div class="row">
                                <div class="col-md-6" style="text-align: left; font-weight: bold; font-size: 8px;">
                                    <span>Cliente: </span>
                                </div>
                                <div class="col-md-6" style="text-align: right; font-size: 8px;">
                                    <span id="clienteDocumento"></span>
                                </div>
                                <div class="col-md-6" style="text-align: left; font-weight: bold; font-size: 8px;">
                                    <span>NIF: </span>
                                </div>
                                <div class="col-md-6" style="text-align: right; font-size: 8px;">
                                    <span id="nifDocumento"></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <section class="product-area">
                <table class="tabela-principal table table-hover table-sm" style="font-size: 7pt; font-family: 'Noto Sans', sans-serif; text-align: justify; margin-bottom: 0;">
                    <thead>
                        <tr style="border-bottom: 1px solid #000;">
                            <td style="text-align: left;">Qtd.</td>
                            <td style="text-align: left;">Producto</td>
                            <td style="text-align: right;">P/Unit.</td>
                            <td style="text-align: right;">Total</td>
                        </tr>
                    </thead>
                    <tbody id="tabelaDocumento">
                    </tbody>
                </table>
            </section>
            <section class="store-user mb-1" style="padding-bottom: .3rem; border-bottom: 1px solid #000; border-top: 1px solid #000;">
                <div class="col-12">
                    <div class="row">
                        <div class="col-12" style="display: flex; justify-content: center; flex-direction: column; padding-top: .3rem;">
                            <div class="row">
                                <div class="col-md-6" style="text-align: left; font-weight: bold; font-size: 8px;">
                                    <span>Utilizador: </span>
                                </div>
                                <div class="col-md-6" style="text-align: right; font-size: 8px;">
                                    <span id="usuarioDocumento"></span>
                                </div>
                                <div class="col-md-6" style="text-align: left; font-weight: bold; font-size: 8px;">
                                    <span>Nº de Itens: </span>
                                </div>
                                <div class="col-md-6" style="text-align: right; font-size: 8px;">
                                    <span id="nItensDocumento"></span>
                                </div>
                                <div class="col-md-6" style="text-align: left; font-weight: bold; font-size: 8px;">
                                    <span>Quantia Recebida: </span>
                                </div>
                                <div class="col-md-6" style="text-align: right; font-size: 8px;">
                                    <span id="recebidoDocumento"></span>
                                </div>
                                <div class="col-md-6" style="text-align: left; font-weight: bold; font-size: 8px;">
                                    <span>Quantia a Pagar: </span>
                                </div>
                                <div class="col-md-6" style="text-align: right; font-size: 8px;">
                                    <span id="aPagarDocumento"></span>
                                </div>
                                <div class="col-md-6" style="text-align: left; font-weight: bold; font-size: 8px;">
                                    <span>Troco: </span>
                                </div>
                                <div class="col-md-6" style="text-align: right; font-size: 8px;">
                                    <span id="trocoDocumento"></span>
                                </div>
                                <div class="col-md-5" style="text-align: left; font-weight: bold; font-size: 8px;">
                                    <span>Modo de Pagamento: </span>
                                </div>
                                <div class="col-md-7" style="text-align: right; font-size: 8px;">
                                    <table class="tabela table table-hover" style="font-size: 8px; font-family: 'Noto Sans', sans-serif; text-align: justify; margin-bottom: .1rem;">
                                        <tbody id="tabelaModoPagamentoDocumento"></tbody>
                                    </table>
                                </div>
                                <div class="col-md-6" style="text-align: left; font-weight: bold; font-size: 8px;">
                                    <span>Total: </span>
                                </div>
                                <div class="col-md-6" style="text-align: right; font-size: 8px;">
                                    <span id="totalDocumento"></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <section class="store-user" style="padding-bottom: 0; border-bottom: 1px solid #000; margin-bottom: .5rem;">
                <div class="col-12">
                    <div class="row pb-1">
                        <div class="col-12" style="display: flex; justify-content: center; flex-direction: column;">

                            <p style="font-size: 6pt; font-family: 'Noto Sans', sans-serif; text-align: center; font-weight: bold;">Contactos:</p>
                            <div class="row">
                                <div class="col-md-6" style="text-align: left; font-weight: bold; font-size: 8px;">
                                    <span>Telefone: </span>
                                </div>
                                <div class="col-md-6" style="text-align: right; font-size: 8px;">
                                    <span id="telefoneDocumento"></span>
                                </div>
                                <div class="col-md-6" style="text-align: left; font-weight: bold; font-size: 8px;">
                                    <span>Email: </span>
                                </div>
                                <div class="col-md-6" style="text-align: right; font-size: 8px;">
                                    <span id="emailDocumento"></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <section class="store-user" style="padding-bottom: 0;">
                <div class="col-12">
                    <div class="row pb-1">
                        <div class="col-12" style="display: flex; justify-content: center; flex-direction: column;">

                            <p style="font-size: 6pt; font-family: 'Noto Sans', sans-serif; text-align: center; font-weight: 100;">*Obrigado e volte sempre!*</p>
                            <p style="font-size: 6pt; font-family: 'Noto Sans', sans-serif; text-align: center; font-weight: 100;">Iva: Regime de Não Sujeição</p>
                            <p style="font-size: 6pt; font-family: 'Noto Sans', sans-serif; text-align: center; font-weight: 100; padding: 0 1.5rem;"> Os bens/serviços foram colocados a disposição do adquirente na data e local do documento.</p>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
    <script src="template/plugins/jquery/jquery.min.js"></script>
    <script>
        $.ajax({
            url: "includes/read/configuracao.inc.php",
            type: "post",
            dataType: "json",
            success: function(data) {
                logotipoDocumento.src = "./images/logo/" + data[0]['valor'];
                nomeEmpresaDocumento.innerText = data[1]['valor'];
                telefoneDocumento.innerText = data[4]['valor'];
                emailDocumento.innerText = data[5]['valor'];
                /*nifDocumento.innerText = data[6]['valor'];
                websiteDocumento.innerText = data[7]['valor'];*/
            }
        });

        function codigoDocumento(codigo, tipoDocumento) {
            $.ajax({
                url: "includes/read/queryCodigoDocumento.inc.php",
                type: "post",
                dataType: "json",
                data: {
                    codigo: codigo.split("/")[1],
                    tipoDocumento: tipoDocumento
                },
                success: function(data) {
                    $.ajax({
                        url: "includes/read/queryDocumentoModoPagamento.inc.php",
                        type: "post",
                        dataType: "json",
                        data: {
                            idDocumento: data[0]['idDocumento'],
                        },
                        success: function(data) {
                            let row = "";
                            for (var key in data) {
                                row += `
                                <tr>
                                    <td style="padding: 0; text-align: right; border: none;">${data[key]['nomeMp']}</td>
                                    <td style="padding: 0; text-align: right; border: none;">${data[key]['valor'].replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
                                </tr>`;
                            }
                            $("#tabelaModoPagamentoDocumento").html(row);
                        }
                    });
                    $.ajax({
                        url: "includes/read/queryDocumentoLinha.inc.php",
                        type: "post",
                        dataType: "json",
                        data: {
                            idDocumento: data[0]['idDocumento'],
                        },
                        success: function(data) {
                            let row = "";
                            for (var key in data) {
                                row += `
                            <tr>
                            <td style="text-align: left;">${parseInt(data[key]['qtdAd']).toFixed(0).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
                            <td style="text-align: left;">${data[key]['descricaoAd']}</td>
                            <td style="text-align: right;">${parseFloat(data[key]['precoAd']).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
                            <td style="text-align: right;">${parseFloat(data[key]['totalAd']).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ")}</td>
                        </tr>
                            `;
                            }
                            $("#tabelaDocumento").html(row);
                        }
                    }).done(function() {
                        let soma = 0;
                        let tabela = document.querySelector('.tabela-principal');
                        for (let i = 1; i < tabela.rows.length; i++) {
                            let valor = parseInt(tabela.rows[i].cells[0].innerText);
                            soma += valor;
                        }
                        nItensDocumento.innerText = soma;
                    });
                }
            }).done(function(data) {
                $.ajax({
                    url: "includes/read/queryDocumento.inc.php",
                    type: "post",
                    dataType: "json",
                    data: {
                        idDocumento: data[0]['idDocumento'],
                    },
                    success: function(data) {
                        nomeTipoDocumento.innerText = data[0]['nomeTd'];
                        viaDocumento.innerText = "ORIGINAL";
                        clienteDocumento.innerText = data[0]['nomeE'].toUpperCase();
                        nifDocumento.innerText = data[0]['nifE'];

                        codigoDocumentoo.innerText = data[0]['codigoDocumento'];
                        dataEmissaoDocumento.innerText = data[0]['dataDoc'];
                        usuarioDocumento.innerText = data[0]['nomeU'];
                        recebidoDocumento.innerText = parseFloat(data[0]['entregue']).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ");
                        aPagarDocumento.innerText = parseFloat(data[0]['total']).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ");
                        trocoDocumento.innerText = parseFloat(data[0]['troco']).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ");

                        //dataVencimentoDocumento.innerText = data[0]['dataDocumento'];
                        //modoPagamentoDocumento.innerText = data[0]['nomePp'];

                        totalDocumento.innerText = parseFloat(data[0]['total']).toFixed(2).replace(/\./g, ',').replace(/\B(?=(\d{3})+(?!\d))/g, " ");
                    }
                });
            });
        }
    </script>
</body>

</html>