<?php
    class VendaModel extends Database {

		protected function insertVenda($idFactura, $totalVenda, $entregue, $troco){
            $stmt = $this->connect();
            $sql = "INSERT INTO venda (idFactura, totalVenda, entregue, troco) VALUES (?, ?, ?, ?)";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($idFactura, $totalVenda, $entregue, $troco)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		protected function insertVendaRecibo($idFactura, $totalVenda, $entregue, $troco, $valorPendente){
            $stmt = $this->connect();
            $sql = "INSERT INTO venda (idFactura, totalVenda, entregue, troco, pendente) VALUES (?, ?, ?, ?, ?)";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($idFactura, $totalVenda, $entregue, $troco, $valorPendente)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		protected function editVendaRecibo($idFactura, $totalVenda, $entregue, $troco, $valorPendente){
			$stmt = $this->connect();
			
            $sql = "UPDATE venda SET entregue = ?, pendente = ? WHERE idFactura = ?";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($entregue, $valorPendente, $idFactura)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		public function listagemVenda(){
			$data = null;
			$sql = "SELECT * FROM venda";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryVenda($idFactura){
			$data = null;
			$sql = "SELECT * FROM venda WHERE idFactura = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idFactura]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function queryTipoTaxa($idTipoTaxa){
			$data = null;
			$sql = "SELECT * FROM tipotaxa WHERE idTipoTaxa = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idTipoTaxa]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

        public function listaTipoTaxa(){
			$data = null;
			$sql = "SELECT * FROM tipotaxa";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}
    }