<?php
class TerminalUsuarioModel extends Database
{

	protected function insertTerminalUsuario($idUsuario, $idTerminal)
	{
		$stmt = $this->connect();
		$sql = "INSERT INTO terminalUsuario (idUsuario, idTerminal) VALUES (?, ?)";
		$query = $stmt->prepare($sql);
		if (!($query->execute(array($idUsuario, $idTerminal)))) {
			$query = null;
			exit();
		}
		$id = $stmt->lastInsertId();
		return $id;
	}

	public function listagemTerminalUsuario()
	{
		$data = null;
		$sql = "SELECT * FROM terminalUsuario";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryTerminalUsuario($idUsuario)
	{
		$data = null;
		$sql = "SELECT * FROM terminalUsuario tu INNER JOIN terminal t ON (tu.idTerminal = t.idTerminal) WHERE tu.idUsuario = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idUsuario]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryTipoTaxa($idTipoTaxa)
	{
		$data = null;
		$sql = "SELECT * FROM tipotaxa WHERE idTipoTaxa = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idTipoTaxa]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function listaTipoTaxa()
	{
		$data = null;
		$sql = "SELECT * FROM tipotaxa";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	protected function editTerminalUsuario($idTerminalUsuario, $idUsuario, $idTerminal)
	{
		$stmt = $this->connect();

		$sql = "UPDATE terminalUsuario SET idUsuario = ?, idTerminal = ? WHERE idTerminalUsuario = ?";
		$query = $stmt->prepare($sql);

		if (!($query->execute(array($idUsuario, $idTerminal, $idTerminalUsuario)))) {
			$query = null;
			exit();
		}
		$id = $stmt->lastInsertId();
		return $id;
	}

	public function deleteTerminalUsuario($idTerminalUsuario)
	{
		$stmt = $this->connect();
		$sql = "DELETE FROM terminalUsuario WHERE idTerminalUsuario = ?";
		$query = $stmt->prepare($sql);
		if (!($query->execute(array($idTerminalUsuario)))) {
			$query = null;
			exit();
		}
	}

	public function autoIncrementTerminalUsuario()
	{
		$sql = "SELECT `AUTO_INCREMENT` AS contador
			FROM INFORMATION_SCHEMA.TABLES
			WHERE TABLE_SCHEMA = 'test1234'
			AND TABLE_NAME = 'terminalUsuario';";
		$stmt = $this->connect()->query($sql);
		$results = $stmt->fetch();
		return $results['contador'];
	}
}
