<?php

class ReservaModel extends Database {

		protected function insertReserva($idUsuario, $origem, $destino, $dataRecepcao, $horaRecepcao, $dataEntrega, $nomeCliente, $sobreNomeCliente, $biCliente, $telefoneCliente, $moradaCliente){
			$sql = "INSERT INTO reserva (idUsuario, origem, destino, dataRecepcao, horaRecepcao, dataEntrega, nomeCliente, sobreNomeCliente, biCliente, telefoneCliente, moradaCliente) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
			$stmt = $this->connect()->prepare($sql);
			if(!$stmt->execute(array($idUsuario, $origem, $destino, $dataRecepcao, $horaRecepcao, $dataEntrega, $nomeCliente, $sobreNomeCliente, $biCliente, $telefoneCliente, $moradaCliente))){
				$stmt = null;
				header("location: ../reservaForm.php?Erro=Inserir!");
				exit();
			}
			$stmt = null;
		}

		public function deleteReserva($idReserva){
			$sql = "DELETE FROM reserva WHERE idReserva = ?";
			$stmt = $this->connect()->prepare($sql);
			$stmt->execute([$idReserva]);
		}

		protected function readReserva(){
			$sql = "SELECT * FROM reserva";
			$stmt = $this->connect()->query($sql);
			while($row = $stmt->fetch()){
				$row['idReserva'];
				$row['idUsuario'];
				$row['origem'];
				$row['destino'];
				$row['dataRecepcao'];
				$row['horaRecepcao'];
				$row['dataEntrega'];
				$row['nomeCliente'];
				$row['sobreNomeCliente'];
				$row['biCliente'];
				$row['telefoneCliente'];
				$row['moradaCliente'];
				$row['confirmacao'];
			}
		}

		protected function updateReserva($origem, $destino, $dataRecepcao, $horaRecepcao, $dataEntrega, $nomeCliente, $sobreNomeCliente, $biCliente, $telefoneCliente, $moradaCliente, $idReserva){
			$sql = "UPDATE reserva SET origem = ?, destino = ?, dataRecepcao = ?, horaRecepcao = ?, dataEntrega = ?, nomeCliente = ?, sobreNomeCliente = ?, biCliente = ?, telefoneCliente = ?, moradaCliente = ? WHERE idReserva = ?";
			$stmt = $this->connect()->prepare($sql);
			if(!$stmt->execute(array($origem, $destino, $dataRecepcao, $horaRecepcao, $dataEntrega, $nomeCliente, $sobreNomeCliente, $biCliente, $telefoneCliente, $moradaCliente, $idReserva))){
				$stmt = null;
				header("location: ../forms/reservaForm.php?Erro=Editar!");
				exit();
			}
			$stmt = null;
		}

		/*protected function deleteReserva($idReserva){
			$sql = "DELETE FROM reserva WHERE idReserva = ?";
			$stmt = $this->connect()->prepare($sql);
			if(!stmt->execute(array($idReserva))){
				$stmt = null;
				header("location: ../forms/reservaForm.php?Erro=Eliminar!");
				exit();
			}
			$stmt = null;
		}*/

		protected function listaReserva(){
			$sql = "SELECT * FROM reserva";
			$stmt = $this->connect()->query($sql);
			while($row = $stmt->fetch()){

				echo '<tr>
					<td>'.$row['idReserva'].'</td>
					<td>'.$row['origem'].'</td>
					<td>'.$row['destino'].'</td>
					<td>'.$row['dataRecepcao'].'</td>
					<td>'.$row['horaRecepcao'].'</td>
					<td>'.$row['dataEntrega'].'</td>
					<td>'.$row['nomeCliente'].'</td>
					<td>'.$row['sobreNomeCliente'].'</td>
					<td>'.$row['biCliente'].'</td>
					<td>'.$row['telefoneCliente'].'</td>
					<td>'.$row['moradaCliente'].'</td>
					<td>'.$row['confirmacao'].'</td>
					<td>
						<a href="../includes/reservaUpdate.inc.php?'.$row['idReserva'].'" data-toggle="modal" data-target="#modal-default"><i class="fa-solid fa-pen-to-square"></i></a>
						<a href="../includes/reservaDelete.inc.php?'.$row['idReserva'].'"><i class="fa-solid fa-trash-can"></i></a>
					</td>
				</tr>';
			}

		}

		protected function countReserva(){
			$sql = "SELECT COUNT(*) FROM reserva";
			$stmt = $this->connect()->query($sql);
			$results = $stmt->fetch();
			echo $results['COUNT(*)'];
		}
	}