<?php
    class OperadorModel extends Database {

		protected function insertOperador($idTipoOperador, $nome, $genero, $bi, $email, $nomeOperador){
			$stmt = $this->connect();
			$senha = uniqid();
			$hashedSenha = password_hash($senha, PASSWORD_DEFAULT);
            $sql = "INSERT INTO Operador (idTipoOperador, nome, genero, bi, email, nomeOperador, senha) VALUES (?, ?, ?, ?, ?, ?, ?)";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($idTipoOperador, $nome, $genero, $bi, $email, $nomeOperador, $hashedSenha)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		protected function insertPeriodoCurso($idOperador, $periodo, $curso){
			$stmt = $this->connect();
			$sql = "INSERT INTO periodoCursoAluno (aluno, periodo, curso) VALUES (?, ?, ?)";
			$query = $stmt->prepare($sql);
			$query->execute(array($idOperador, $periodo, $curso));
        }

		protected function insertTurmaAluno($idTurma, $idAluno){
			$stmt = $this->connect();
			
            $sql = "INSERT INTO turmaaluno (turma, aluno) VALUES (?, ?)";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($idTurma, $idAluno)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		protected function tipoOperador($idTipoOperador){
			
		}

		public function readTurma(){
			$data = null;
			$sql = "SELECT * FROM turma";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		protected function editTurma($idTurma, $capacidade){
			$stmt = $this->connect();
			
            $sql = "UPDATE turma SET capacidade = ? WHERE idTurma = ?";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($capacidade, $idTurma)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		protected function readTipoOperador($idOperador){
			$data = null;
			$sql = "SELECT * FROM Operador WHERE idOperador = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idOperador]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function fotoPerfil($idOperador){
			$data = null;
			$sql = "SELECT * FROM Operador WHERE idOperador = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idOperador]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function deleteOperador($idOperador){
			$stmt = $this->connect();
            $sql = "DELETE FROM Operador WHERE idOperador = ?";
            $query = $stmt->prepare($sql);
			$img = $this->fotoPerfil($idOperador);
			$nameImg = "../../images/fotoPerfil/" . $img[0]["imagem"];
			$fileInfo = glob($nameImg);
			$fileExt = explode(".", $fileInfo[0]);
			$fileActualExt = $fileExt[5];
        	$file = $nameImg;
			unlink($file);
            if(!($query->execute(array($idOperador)))){
				$query = null;
				exit();
			}
		}

		protected function editOperador($idOperador, $idTipoOperador, $nome, $genero, $bi, $email, $nomeOperador){
			$stmt = $this->connect();
			
            $sql = "UPDATE Operador SET idTipoOperador = ?, nome = ?, genero = ?, bi = ?, email = ?, nomeOperador = ? WHERE idOperador = ?";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($idTipoOperador, $nome, $genero, $bi, $email, $nomeOperador, $idOperador)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		public function listagemAluno(){
			$data = null;
			$sql = "SELECT * FROM viewOperadortipoidentificador WHERE idTipoOperador = 2";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function listagemProfessor(){
			$data = null;
			$sql = "SELECT * FROM viewOperadortipo WHERE idTipoOperador = 3";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function listagemOperador(){
			$data = null;
			$sql = "SELECT * FROM operador";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

        public function querydataNasc($dataNasc){
			$data = null;
			$sql = "SELECT COUNT(*) AS contador FROM Operador WHERE dataNasc = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$dataNasc]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryEmail($email){
			$data = null;
			$sql = "SELECT COUNT(*) AS contador FROM Operador WHERE email = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$email]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryNomeOperador($nomeOperador){
			$data = null;
			$sql = "SELECT COUNT(*) AS contador FROM Operador WHERE nomeOperador = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$nomeOperador]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function listaOperador(){
			$data = null;
			$sql = "SELECT * FROM Operador";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryAluno($turma){
			$data = null;
			if($turma == 0){
				$sql = "SELECT * FROM turmaaluno ta INNER JOIN viewOperadortipo u ON (ta.aluno=u.idOperador)";
				if($stmt = $this->connect()->query($sql)){
					while($row = $stmt->fetch()){
					$data[] = $row;
					}
				}
			} else {
				$sql = "SELECT * FROM turmaaluno ta INNER JOIN viewOperadortipo u ON (ta.aluno=u.idOperador) WHERE ta.turma = ?";
				if($stmt = $this->connect()->prepare($sql)){
					$stmt->execute([$turma]);
					while($row = $stmt->fetch()){
					$data[] = $row;
					}
				}
			}
			return $data;
		}

		public function dataAluno($idAluno){
			$data = null;
			$sql = "SELECT * FROM viewdataaluno WHERE idTipoOperador = 2 AND idOperador = ? ORDER BY idOperador ASC";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idAluno]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function dataOperador($idOperador){
			$data = null;
			$sql = "SELECT * FROM viewdataOperador WHERE NOT idTipoOperador BETWEEN 2 AND 3 AND idOperador = ? ORDER BY idOperador ASC";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idOperador]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function codigoOperador($idOperador){
			$data = null;
			$sql = "SELECT * FROM viewidentificadoruser WHERE idOperador = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idOperador]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function queryOperador($idOperador){
			$data = null;
			$sql = "SELECT * FROM viewOperadortipoOperador WHERE idOperador = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idOperador]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryUser($idOperador, $senha){
			$data = null;
			$sql = "SELECT * FROM Operador WHERE idOperador = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idOperador]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			$pwdHashed = $data[0]["senha"];
			$checkPwd = password_verify($senha, $pwdHashed);
			return $checkPwd;
		}

		public function updateSenha($idOperador, $senha){
			$stmt = $this->connect();
			
            $sql = "UPDATE Operador SET senha = ? WHERE idOperador = ?";
            $query = $stmt->prepare($sql);
			
			$hashedSenha = password_hash($senha, PASSWORD_DEFAULT);
            if(!($query->execute(array($hashedSenha, $idOperador)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $senha;
        }
    }