<?php
    class ModoPagamentoModel extends Database {

		protected function insertModoPagamento($nome, $mecanismoPagamento, $nota){
            $stmt = $this->connect();
            $sql = "INSERT INTO modoPagamento (nome, mecanismoPagamento, nota) VALUES (?, ?, ?)";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($nome, $mecanismoPagamento, $nota)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		public function listagemModoPagamento(){
			$data = null;
			$sql = "SELECT * FROM modoPagamento";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryModoPagamento($idModoPagamento){
			$data = null;
			$sql = "SELECT * FROM modoPagamento WHERE idModoPagamento = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idModoPagamento]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

        public function listaTipoTaxa(){
			$data = null;
			$sql = "SELECT * FROM tipotaxa";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		protected function editModoPagamento($idModoPagamento, $nome, $mecanismoPagamento, $nota){
			$stmt = $this->connect();
			
            $sql = "UPDATE modoPagamento SET nome = ?, mecanismoPagamento = ?, nota = ? WHERE idModoPagamento = ?";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($nome, $mecanismoPagamento, $nota, $idModoPagamento)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		public function deleteModoPagamento($idModoPagamento){
			$stmt = $this->connect();
            $sql = "DELETE FROM modoPagamento WHERE idModoPagamento = ?";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($idModoPagamento)))){
				$query = null;
				exit();
			}
		}

		public function autoIncrementModoPagamento()
	{
		$sql = "SELECT `AUTO_INCREMENT` AS contador
			FROM INFORMATION_SCHEMA.TABLES
			WHERE TABLE_SCHEMA = 'test1234'
			AND TABLE_NAME = 'modoPagamento';";
		$stmt = $this->connect()->query($sql);
		$results = $stmt->fetch();
		return $results['contador'];
	}
    }