<?php
    class FacturaModel extends Database {

		protected function insertFactura($idUsuario, $idTipoUsuario, $idTipoMatricula, $matricula, $nomeCliente, $nifCliente, $precoMatricula, $nProcesso, $nQuadro, $placaFrente, $placaTras, $classeVeiculo, $servico, $estado, $estadoProducao){
			$stmt = $this->connect();
            $sql = "INSERT INTO factura (idUsuario, idTipoUsuario, idTipoMatricula, matricula, nomeCliente, nifCliente, precoMatricula, nProcesso, nQuadro, placaFrente, placaTras, classeVeiculo, servico, estado, estadoProducao, idTipoDoc) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($idUsuario, $idTipoUsuario, $idTipoMatricula, $matricula, $nomeCliente, $nifCliente, $precoMatricula, $nProcesso, $nQuadro, $placaFrente, $placaTras, $classeVeiculo, $servico, $estado, $estadoProducao, 2)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		protected function insertDocumento($idUsuario, $idTipoUsuario, $idTipoMatricula, $matricula, $nomeCliente, $nifCliente, $precoMatricula, $nProcesso, $nQuadro, $placaFrente, $placaTras, $classeVeiculo, $servico, $idTipoDoc, $moradaCliente, $codigoPostalCliente, $estado, $estadoProducao){
			$stmt = $this->connect();
            $sql = "INSERT INTO factura (idUsuario, idTipoUsuario, idTipoMatricula, matricula, nomeCliente, nifCliente, precoMatricula, nProcesso, nQuadro, placaFrente, placaTras, classeVeiculo, servico, idTipoDoc, moradaCliente, codigoPostalCliente, estado, estadoProducao) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($idUsuario, $idTipoUsuario, $idTipoMatricula, $matricula, $nomeCliente, $nifCliente, $precoMatricula, $nProcesso, $nQuadro, $placaFrente, $placaTras, $classeVeiculo, $servico, $idTipoDoc, $moradaCliente, $codigoPostalCliente, $estado, $estadoProducao)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		protected function insertRecibo($idUsuario, $idTipoUsuario, $idTipoMatricula, $matricula, $nomeCliente, $nifCliente, $precoMatricula, $nProcesso, $nQuadro, $placaFrente, $placaTras, $classeVeiculo, $servico, $estado, $estadoProducao, $idTipoDoc, $moradaCliente, $codigoPostalCliente, $idFactura){
			$stmt = $this->connect();
            $sql = "INSERT INTO factura (idUsuario, idTipoUsuario, idTipoMatricula, matricula, nomeCliente, nifCliente, precoMatricula, nProcesso, nQuadro, placaFrente, placaTras, classeVeiculo, servico, estadoProducao, idTipoDoc, moradaCliente, codigoPostalCliente, assocDoc) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($idUsuario, $idTipoUsuario, $idTipoMatricula, $matricula, $nomeCliente, $nifCliente, $precoMatricula, $nProcesso, $nQuadro, $placaFrente, $placaTras, $classeVeiculo, $servico, $estadoProducao, $idTipoDoc, $moradaCliente, $codigoPostalCliente, $idFactura)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		public function listagemMatricula(){
			$data = null;
			$sql = "SELECT * FROM viewinfovenda WHERE fEstado = 0;";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function listagemMatriculaFifo(){
			$data = null;
			$sql = "SELECT * FROM viewinfovenda WHERE fEstado = 0 ORDER BY vDataVenda DESC;";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function totalFactura(){
			$data = null;
			$sql = "SELECT COUNT(*) AS contador FROM viewinfovenda;";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function listagemTotalFactura(){
			$data = null;
			$sql = "SELECT * FROM viewinfovenda;";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function totalMatriculaProduzida(){
			$data = null;
			$sql = "SELECT COUNT(*) AS contador FROM viewinfovenda WHERE fEstado = 1;";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function listMatriculaProduzida(){
			$data = null;
			$sql = "SELECT * FROM viewinfovenda WHERE fEstado = 1;";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function totalMatriculaPendente(){
			$data = null;
			$sql = "SELECT COUNT(*) AS contador FROM viewinfovenda WHERE fEstado = 0;";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function listMatriculaPendente(){
			$data = null;
			$sql = "SELECT * FROM viewinfovenda WHERE fEstado = 0;";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function contadorMatricula($idTipoMatricula){
			$data = null;
			$sql = "SELECT COUNT(*) AS contador FROM viewinfovenda WHERE fIdTipoMatricula = ? AND fEstado = 0;";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idTipoMatricula]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function queryMatriculaTipo($idTipoMatricula){
			$data = null;
			$sql = "SELECT * FROM viewinfovenda WHERE fIdTipoMatricula = ? AND fEstado = 0 ORDER BY fIdFactura;";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idTipoMatricula]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function listagemMatriculaProduzida(){
			$data = null;
			$sql = "SELECT * FROM viewinfovenda WHERE fStatus = 'Produzida' OR fStatus = 'Segunda-Via (Produzida)' AND fEstado = 1;";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function listagemMatriculaPendente(){
			$data = null;
			$sql = "SELECT * FROM viewinfovenda WHERE fStatus = 'Pendente' OR fStatus = 'Segunda-Via (Pendente)' AND fEstado = 1;";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function listagemMatriculaReproduzida(){
			$data = null;
			$sql = "SELECT * FROM viewinfovenda WHERE fStatus = 'Reproduzida' AND fEstado = 1;";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryFacturaPendente($tipoDocumento, $valor){
			$data = null;
			$sql = "SELECT *, CONCAT(tdCodigo, ' ', YEAR(vDataVenda), '/', idDescricao) AS fac FROM viewinfovenda WHERE tdIdTipoDoc = ? AND fMatricula = ? AND vEntregue < fPrecoMatricula;";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$tipoDocumento, $valor]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function queryDocumento($tipoDocumento, $valor){
			$data = null;
			$sql = "SELECT * FROM viewinfovenda WHERE tdIdTipoDoc = ? AND idDescricao = ?;";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$tipoDocumento, $valor]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function queryAllDocumento($tipoDocumento){
			$data = null;
			$sql = "SELECT * FROM viewinfovenda WHERE tdIdTipoDoc = ?;";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$tipoDocumento]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function queryRecibo($idFactura){
			$data = null;
			$sql = "SELECT SUM(vEntregue) AS soma FROM viewinfovenda WHERE fAssocDoc = ?;";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idFactura]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function updateFacturaEstado($idFactura){
			$stmt = $this->connect();
			
            $sql = "UPDATE factura SET estado = 1 WHERE idFactura = ?";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($idFactura)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

    }